/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.event;

import com.google.common.collect.Queues;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="epicacg", value={Dist.CLIENT})
public class RenderEvents {
    static Queue<UUID> waitToRemove = Queues.newArrayDeque();
    static ConcurrentHashMap<UUID, TickTimer> hiddenEntity = new ConcurrentHashMap();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            hiddenEntity.forEach((k, v) -> {
                v.tick();
                if (v.isEnded()) {
                    waitToRemove.add((UUID)k);
                }
            });
            while (!waitToRemove.isEmpty()) {
                UUID uuid = waitToRemove.poll();
                hiddenEntity.remove(uuid);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void OnLivingEntityRender(RenderLivingEvent.Pre<?, ?> event) {
        if (hiddenEntity.size() == 0) {
            return;
        }
        if (hiddenEntity.containsKey(event.getEntity().m_20148_())) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    public static void HiddenEntity(LivingEntity entity, int maxTime) {
        if (hiddenEntity.containsKey(entity.m_20148_())) {
            hiddenEntity.get(entity.m_20148_()).setTime(maxTime);
        } else {
            hiddenEntity.put(entity.m_20148_(), new TickTimer(maxTime));
        }
    }

    public static void UnhiddenEntity(LivingEntity entity) {
        hiddenEntity.remove(entity.m_20148_());
    }

    static class TickTimer {
        int time;

        TickTimer(int time) {
            this.time = time;
        }

        public void tick() {
            if (this.time > 0) {
                --this.time;
            }
        }

        public void setTime(int time) {
            this.time = time;
        }

        public boolean isEnded() {
            return this.time <= 0;
        }
    }
}

